class Lager {
	private int bilanz;
 	private int anz;
 	private static final int MANZ = 20;
 	private KonThread konsument;

	Lager(int start) {
		bilanz = start;
		System.out.println("Der Laden ist offen (Bestand = " + bilanz+")\n");
	}

	void setzeKonsument(KonThread kon) {
		konsument = kon;
	}
	
	synchronized boolean offen() {
		if (anz < MANZ)
			return true;
		else {
			System.out.println("\nLieber " + Thread.currentThread().getName() +
				", es ist Feierabend!");
			return false;
		}
	}

	private String formZeit() {
		return java.text.DateFormat.getTimeInstance().format(new java.util.Date());
	}

	synchronized void ergaenze(int add) {
		bilanz += add;
		anz++;
		System.out.println("Nr. " + anz + ":\t"+Thread.currentThread().getName() +
			" ergänzt\t" + add + "\tum " + formZeit() + " Uhr. Stand: " + bilanz);
		if (bilanz < 50 && konsument.isAlive()) {
			System.out.println("\n" + konsument.getName() +
					" sollte wegen Lager < 50 enden um " + formZeit() + " Uhr. Stand: " + bilanz);
			konsument.interrupt();
		}
	}

	synchronized void liefere(int sub) {
		bilanz -= sub;
		anz++;
		System.out.println("Nr. " + anz + ":\t" + konsument.getName() +
			" entnimmt\t" + sub + "\tum " + formZeit() + " Uhr. Stand: " + bilanz);
	}
}